// my-menu-manager-admin-script.js

jQuery(document).ready(function($) {
    console.log("Mi script de administración para ordenar se está ejecutando desde un archivo externo.");

    // Función para inicializar Sortable en una tabla específica
    function initializeSortable(tableSelector) {
        // Asegúrate de que el elemento exista antes de inicializar Sortable
        if ($(tableSelector).length) {
            $(tableSelector).sortable({
                items: "tr.menu-item-row",
                opacity: 0.8,
                cursor: "grabbing",
                handle: ".handle", // Solo el icono de mover es el "handle"
                axis: "y", // Solo permite arrastrar verticalmente
                update: function(event, ui) {
                    // No se necesita lógica aquí para guardar, el orden se mantiene en el DOM
                    // y se recogerá correctamente al enviar el formulario completo.
                }
            });
        }
    }

    // Inicializar sortable en todas las tablas existentes al cargar
    $("#menu-categories-container").find(".sortable-items-list").each(function() {
        initializeSortable($(this));
    });

    // --- Lógica para eliminar filas ---
    $(document).on("click", ".remove-item-row", function() {
        if (confirm("¿Estás seguro de que quieres eliminar este plato/vino? Los cambios se guardarán al enviar el formulario.")) {
            $(this).closest("tr.menu-item-row").remove();
            console.log("DEBUG: Fila de plato/vino eliminada del DOM.");
        }
    });

    // --- Lógica para eliminar bloques de categoría ---
    $(document).on("click", ".remove-category-block", function() {
        if (confirm("¿Estás seguro de que quieres eliminar esta sección y todos sus platos? Esta acción es irreversible y los cambios se guardarán al enviar el formulario.")) {
            $(this).closest(".menu-category-block").remove();
            console.log("DEBUG: Bloque de categoría eliminado del DOM.");
        }
    });


    // --- Lógica para "Añadir Plato / Vino" (basada en recarga) ---
    $(document).on("click", ".add-item-row-btn", function(e) {
        e.preventDefault(); // Prevenir el comportamiento por defecto si fuera un submit de un form anidado

        console.log("DEBUG: Clic en 'Añadir Plato / Vino' detectado.");
        const categoryNameToAddItems = $(this).data("category-name-for-add");
        console.log("DEBUG: categoryNameToAddItems:", categoryNameToAddItems);

        if (categoryNameToAddItems) {
            $("#add-new-items-request").val(categoryNameToAddItems); // Almacena el nombre de la categoría
            $("#add-new-category-request").val("0"); // Asegurarse de que no se pida una nueva categoría al mismo tiempo
            console.log("DEBUG: Valores de inputs ocultos actualizados para añadir item.");
            $("#menu-manager-form").submit(); // Envía el formulario para guardar y recargar
            console.log("DEBUG: Formulario enviado para añadir plato/vino.");
        } else {
            alert("No se pudo identificar la categoría para añadir el plato/vino. Recarga la página e inténtalo de nuevo.");
            console.error("ERROR: No se encontró data-category-name-for-add en el botón 'Añadir Plato / Vino'.");
        }
    });

    // --- Lógica para "Añadir Nueva Sección / Categoría" (basada en recarga) ---
    $(document).on("click", ".add-new-category-btn", function(e) {
        e.preventDefault(); // Prevenir el comportamiento por defecto

        console.log("DEBUG: Clic en 'Añadir Nueva Sección / Categoría' detectado.");
        const categoryName = prompt("Introduce el nombre de la nueva sección/categoría:");
        console.log("DEBUG: Nombre de categoría introducido:", categoryName);

        if (categoryName && categoryName.trim() !== '') { // Asegura que no esté vacío
            $("#add-new-category-request").val("1");
            $("#add-new-category-name").val(categoryName.trim());
            $("#add-new-items-request").val(""); // Asegurarse de que no se pida añadir items al mismo tiempo
            console.log("DEBUG: Valores de inputs ocultos actualizados para añadir categoría.");
            $("#menu-manager-form").submit(); // Envía el formulario para guardar y recargar
            console.log("DEBUG: Formulario enviado para añadir categoría.");
        } else if (categoryName !== null) { // Si no es null (cancelar), pero está vacío
            alert("El nombre de la categoría no puede estar vacío.");
            console.warn("ADVERTENCIA: Intento de añadir categoría con nombre vacío.");
        } else {
            console.log("DEBUG: Añadir nueva categoría cancelado por el usuario.");
        }
    });

    // Actualizar el valor del input hidden category_original_name
    $(document).on("change", ".category-name-input", function() {
        const newName = $(this).val();
        // Encuentra el input hidden de nombre original de la categoría dentro del mismo bloque
        $(this).closest(".menu-category-block").find(".category-original-name-input").val(newName);

        // Además, actualiza el valor del input 'category' en cada fila de la tabla de items asociada
        // con este bloque de categoría. Esto asegura que si se cambia el nombre de la categoría
        // antes de guardar, los items se asocien al nuevo nombre.
        const categoryBlockId = $(this).closest(".menu-category-block").data("category-block-id");
        $(`.items-table[data-category-block-id="${categoryBlockId}"] .item-category-input`).val(newName);
        console.log(`DEBUG: Nombre de categoría cambiado a '${newName}'. Inputs de categoría de ítems actualizados.`);
    });


    // Para asegurar que la pestaña actual se mantenga al recargar
    const urlParams = new URLSearchParams(window.location.search);
    const tab = urlParams.get("tab");
    if (tab) {
        $(".nav-tab").removeClass("nav-tab-active");
        $(`.nav-tab[href*="tab=${tab}"]`).addClass("nav-tab-active");
        $("#current-tab-input").val(tab);
        console.log("DEBUG: Pestaña actual detectada y establecida:", tab);
    }
});